unit enigma_keygen_ide;

interface

Uses Windows;

const
  // Key generation constants
  ERROR_UNKNOWN                       = $FFFFFFFF;
  ERROR_OK                            = $00000000;
  ERROR_KEY_BUFFER_NOT_ALLOCATED      = $00000001;
  ERROR_KEY_BUFFER_LESS               = $00000002;
  ERROR_REGINFO_BUFFER_NOT_ALLOCATED  = $00000003;
  ERROR_REGINFO_BUFFER_EMPTY          = $00000004;
  ERROR_HARDWARE_TYPE_UNKNOWN         = $00000005;
  ERROR_HARDWARE_ID                   = $00000006;
  ERROR_HARDWARE_BUFFER_NOT_ALLOCATED = $00000007;
  ERROR_HARDWARE_BUFFER_EMPTY         = $00000008;
  ERROR_INVALID_CONSTANT_D            = $00000009;
  ERROR_INVALID_CONSTANT_N            = $0000000A;
  ERROR_INVALID_CONSTANT_A            = $0000000B;
  ERROR_INVALID_CONSTANT_B            = $0000000C;
  ERROR_PROJECT_FILE_NOT_FOUND        = $0000000D;
  ERROR_PROJECT_FILE_INVALID          = $0000000E;
  ERROR_INVALID_CONSTANT_E            = $0000000F;
  ERROR_INVALID_KEYTYPE               = $00000010;
  ERROR_INVALID_REGINFO               = $00000011;

  // Hardware locking type constants
  HID_ERROR           = 00000000;
  HID_HARDDISK        = 00000001;
  HID_VOLUMENAME      = 00000002;
  HID_CPUTYPE         = 00000004;
  HID_COMPUTERNAME    = 00000008;
  HID_MOTHERBOARDBIOS = 00000016;
  HID_WINDOWSSERIAL   = 00000032;
  HID_HDDSERIAL       = 00000064;

  // Number of crypted sections
  NUMBER_OF_CRYPTED_SECTIONS = 16;

  // Key type
  KEY_TYPE_LONG  = 0;
  KEY_TYPE_SHORT = 1;

  // Key format
  KEY_FORMAT_10 = 10;
  KEY_FORMAT_16 = 16;
  KEY_FORMAT_32 = 32;
  KEY_FORMAT_64 = 64;

type
  TGenKeyParams = record
    KeyType            : byte;      // Key Type
    KeyFormat          : byte;      // Key format
    Reserved3          : word;      // Reserved
    Key                : pointer;   // Key buffer
    KeyLen             : dword;     // Key buffer length
    RegInfo            : pointer;   // User info buffer
    RegInfoLen         : dword;     // User info buffer length
    UseKeyExpiration   : byte;      // Use expiration date?
    Reserved1          : byte;      // Reserver
    ExpirationYear     : word;      // ***
    ExpirationMonth    : byte;      // *** Key expiration date
    ExpirationDay      : byte;      // ***
    UseHardwareLocking : byte;      // Use Hardware lock?
    Reserved2          : byte;      // Reserved
    HardwareID         : PAnsiChar; // Hardware locking info
    EncryptedSections  : array [1..NUMBER_OF_CRYPTED_SECTIONS] of byte; // Crypted sections
    D                  : PAnsiChar; // ***
    N                  : PAnsiChar; // *** Secure constants from project file
    A                  : PAnsiChar; // ***
    B                  : PAnsiChar; // ***
  end;
  PGenKeyParams = ^TGenKeyParams;

  TVerifyKey = record
    Key                : PAnsiChar; // Registration key
    KeyType            : byte;      // Key type
    KeyFormat          : byte;      // Key format
    Reserved1          : word;      // Reserved
    RegInfo            : PAnsiChar; // Registration info
    CreateDay          : byte;      // ***
    CreateMonth        : byte;      // *** Key created date
    CreateYear         : word;      // ***
    UseKeyExpiration   : byte;      // Used expiration?
    Reserved2          : byte;      // Reserved
    ExpirationYear     : word;      // ***
    ExpirationMonth    : byte;      // *** Key expiration date
    ExpirationDay      : byte;      // ***
    UseHardwareLocking : byte;      // Used Hadware locking?
    HardwareIDType     : byte;      // Type of Hardware locking
    HardwareID         : array [0..16] of char; // Hardware ID
    EncryptedSections  : array [1..NUMBER_OF_CRYPTED_SECTIONS] of byte;
    N : PAnsiChar;                  // ***
    E : PAnsiChar;                  // *** Secure constants from project file
    B : PAnsiChar;                  // ***
    A : PAnsiChar;                  // ***
  end;
  PVerifyKey = ^TVerifyKey;


function KG_GenerateRegistrationKey(GenKeyParams : PGenKeyParams) : dword; stdcall;
function KG_GenerateRegistrationKeyFromProject(ProjectFile : PChar; GenKeyParams : PGenKeyParams) : dword; stdcall;
function KG_VerifyRegistrationInfo(VerifyKey : PVerifyKey) : dword; stdcall;
function KG_VerifyRegistrationInfoFromProject(ProjectFile : PChar; VerifyKey : PVerifyKey) : dword; stdcall;

implementation

const
  keygen_api_dll_name  = 'keygen.dll';

function KG_GenerateRegistrationKey(GenKeyParams : PGenKeyParams) : dword; external keygen_api_dll_name name 'KG_GenerateRegistrationKey';
function KG_GenerateRegistrationKeyFromProject(ProjectFile : PChar; GenKeyParams : PGenKeyParams) : dword; external keygen_api_dll_name name 'KG_GenerateRegistrationKeyFromProject';
function KG_VerifyRegistrationInfo(VerifyKey : PVerifyKey) : dword; external keygen_api_dll_name name 'KG_VerifyRegistrationInfo';
function KG_VerifyRegistrationInfoFromProject(ProjectFile : PChar; VerifyKey : PVerifyKey) : dword; external keygen_api_dll_name name 'KG_VerifyRegistrationInfoFromProject';

end.
